/*
 * Decompiled with CFR 0.152.
 */
package com.vistara.scc.model.rules;

import com.vistara.scc.model.rules.AttributeType;
import com.vistara.sdk.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;

public enum RuleOperatorType {
    EQUALS("Equals"),
    CONTAINS("Contains"),
    STARTSWITH("Starts with"),
    ENDSWITH("Ends with"),
    NOTEQUALS("Not Equals"),
    NOTCONTAINS("Not Contains"),
    NOTSTARTSWITH("Not Starts With"),
    NOTENDSWITH("Not Ends With"),
    IS("Is"),
    NOT("Not"),
    EQUALTO("Equals to"),
    NOTEQUALSTO("Not Equals to"),
    LESSTHAN("Less than"),
    GREATERTHAN("Greater than"),
    LESSTHANOREQUALSTO("Less than or equals to"),
    GREATERTHANOREQUALTO("Greater than or equal to"),
    ON("On"),
    NOTON("Not On"),
    BEFORE("Before"),
    ONORBEFORE("On or Before"),
    AFTER("After"),
    ONORAFTER("On or After"),
    MODELEQUALSTO("Is "),
    MODELNOTEQUALSTO("Is Not"),
    MATCHES("Regex"),
    MATCH("Is"),
    NOTMATCH("Is Not"),
    LISTCONTAINS("Equals"),
    LISTNOTCONTAINS("Not Equals");

    private String name;

    private RuleOperatorType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static RuleOperatorType getRuleOperatorType(String ruleOperatorType) {
        for (RuleOperatorType value : RuleOperatorType.values()) {
            if (!value.name().equalsIgnoreCase(ruleOperatorType)) continue;
            return value;
        }
        throw new IllegalArgumentException("No Enum specified for this string");
    }

    public static List<RuleOperatorType> getRuleOperatorsByAttributeType(AttributeType attributeType) {
        ArrayList<RuleOperatorType> ruleOperatorTypes = new ArrayList<RuleOperatorType>();
        if (attributeType == null || AttributeType.STRING.equals((Object)attributeType)) {
            ruleOperatorTypes.add(CONTAINS);
            ruleOperatorTypes.add(NOTCONTAINS);
            ruleOperatorTypes.add(EQUALS);
            ruleOperatorTypes.add(NOTEQUALS);
            ruleOperatorTypes.add(STARTSWITH);
            ruleOperatorTypes.add(ENDSWITH);
            ruleOperatorTypes.add(MATCHES);
        } else if (AttributeType.BOOLEAN.equals((Object)attributeType)) {
            ruleOperatorTypes.add(IS);
        } else if (AttributeType.NUMERIC.equals((Object)attributeType)) {
            ruleOperatorTypes.add(EQUALTO);
            ruleOperatorTypes.add(NOTEQUALSTO);
            ruleOperatorTypes.add(LESSTHAN);
            ruleOperatorTypes.add(GREATERTHAN);
            ruleOperatorTypes.add(LESSTHANOREQUALSTO);
            ruleOperatorTypes.add(GREATERTHANOREQUALTO);
            ruleOperatorTypes.add(MATCHES);
        } else if (AttributeType.DATE.equals((Object)attributeType)) {
            ruleOperatorTypes.add(BEFORE);
            ruleOperatorTypes.add(ONORBEFORE);
            ruleOperatorTypes.add(AFTER);
            ruleOperatorTypes.add(ONORAFTER);
        } else if (AttributeType.DROPDOWN.equals((Object)attributeType)) {
            ruleOperatorTypes.add(MATCH);
            ruleOperatorTypes.add(NOTMATCH);
        } else if (AttributeType.MODELENTITY.equals((Object)attributeType)) {
            ruleOperatorTypes.add(MODELEQUALSTO);
            ruleOperatorTypes.add(MODELNOTEQUALSTO);
        } else if (AttributeType.LIST.equals((Object)attributeType)) {
            ruleOperatorTypes.add(LISTCONTAINS);
            ruleOperatorTypes.add(LISTNOTCONTAINS);
        }
        return ruleOperatorTypes;
    }

    public static String getHQLOperatorByRuleOperatorType(RuleOperatorType ruleOperatorType) {
        switch (ruleOperatorType) {
            case STARTSWITH: 
            case ENDSWITH: 
            case CONTAINS: {
                return " LIKE ";
            }
            case NOTSTARTSWITH: 
            case NOTENDSWITH: 
            case NOTCONTAINS: {
                return " NOT  LIKE ";
            }
            case IS: 
            case EQUALS: 
            case EQUALTO: 
            case ON: 
            case MODELEQUALSTO: {
                return " = ";
            }
            case NOT: 
            case NOTEQUALS: 
            case NOTEQUALSTO: 
            case NOTON: 
            case MODELNOTEQUALSTO: {
                return " != ";
            }
            case LESSTHAN: 
            case BEFORE: {
                return " < ";
            }
            case LESSTHANOREQUALSTO: 
            case ONORBEFORE: {
                return " <= ";
            }
            case GREATERTHAN: 
            case AFTER: {
                return " > ";
            }
            case GREATERTHANOREQUALTO: 
            case ONORAFTER: {
                return " >= ";
            }
            case MATCHES: {
                return " regexp() ";
            }
        }
        return " LIKE ";
    }

    public static String getOperatorAndattributeNameQuerySyntax(String objAliasName, String attributeName, String operator2) {
        String queryexpression = "";
        queryexpression = StringUtil.isEmpty(operator2) ? null : (operator2.contains("regexp()") ? " regexp(" + objAliasName + "." + attributeName + " , ? ) = 1 " : " " + objAliasName + "." + attributeName + " " + operator2 + " ? ");
        return queryexpression;
    }

    public static List<RuleOperatorType> getIntegrationRuleOperatorsByAttributeType(AttributeType attributeType) {
        ArrayList<RuleOperatorType> ruleOperatorTypes = new ArrayList<RuleOperatorType>();
        if (attributeType == null || AttributeType.STRING.equals((Object)attributeType)) {
            ruleOperatorTypes.add(CONTAINS);
            ruleOperatorTypes.add(NOTCONTAINS);
            ruleOperatorTypes.add(EQUALS);
            ruleOperatorTypes.add(NOTEQUALS);
            ruleOperatorTypes.add(STARTSWITH);
            ruleOperatorTypes.add(ENDSWITH);
            ruleOperatorTypes.add(MATCHES);
        } else if (AttributeType.DROPDOWN.equals((Object)attributeType)) {
            ruleOperatorTypes.add(IS);
            ruleOperatorTypes.add(NOT);
        } else if (AttributeType.ENUM.equals((Object)attributeType)) {
            ruleOperatorTypes.add(EQUALS);
            ruleOperatorTypes.add(NOTEQUALS);
        } else if (AttributeType.BOOLEAN.equals((Object)attributeType)) {
            ruleOperatorTypes.add(IS);
        }
        return ruleOperatorTypes;
    }
}

